/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.CapabilityItemHandler;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Refills your hotbar from your inventory.", hasSubscriptions=true)
public class AutoRestock
extends CharmModule {
    private final Map<PlayerEntity, EnumMap<Hand, StackData>> handCache = new WeakHashMap<PlayerEntity, EnumMap<Hand, StackData>>();

    public static void addItemUsedStat(PlayerEntity player, ItemStack stack) {
        if (ModuleHandler.enabled(AutoRestock.class)) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            EnumMap cached = this.handCache.computeIfAbsent((PlayerEntity)player, it -> new EnumMap(Hand.class));
            for (Hand hand : Hand.values()) {
                StackData stackData = (StackData)cached.get(hand);
                if (stackData != null && player.func_184586_b(hand).func_190926_b() && this.getItemUsed(player, stackData.item) > stackData.used) {
                    this.findReplacement(player, hand, stackData);
                }
                this.updateCache(player, hand, cached);
            }
        }
    }

    private void updateCache(ServerPlayerEntity player, Hand hand, EnumMap<Hand, StackData> cached) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            cached.put(hand, null);
        } else {
            Item item = stack.func_77973_b();
            int used = this.getItemUsed(player, item);
            ListNBT enchantments = stack.func_77986_q();
            StackData stackData = cached.get(hand);
            if (stackData == null) {
                stackData = new StackData();
                cached.put(hand, stackData);
            }
            stackData.item = item;
            stackData.enchantments = enchantments;
            stackData.used = used;
        }
    }

    private int getItemUsed(ServerPlayerEntity player, Item item) {
        return player.func_147099_x().func_77444_a(Stats.field_75929_E.func_199076_b((Object)item));
    }

    private void findReplacement(ServerPlayerEntity player, Hand hand, StackData stackData) {
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(inventory -> {
            for (int i = 9; i < inventory.getSlots(); ++i) {
                ItemStack possibleReplacement = inventory.extractItem(i, Integer.MAX_VALUE, true);
                if (stackData.item != possibleReplacement.func_77973_b() || !Objects.equals(stackData.enchantments, possibleReplacement.func_77986_q())) continue;
                player.func_184611_a(hand, possibleReplacement.func_77946_l());
                inventory.extractItem(i, Integer.MAX_VALUE, false);
                break;
            }
        });
    }

    private static class StackData {
        private Item item;
        private ListNBT enchantments;
        private int used;

        private StackData() {
        }
    }
}

